const products = [
  { id: 1, name: "Headphones", price: 40, category: "electronics",
    description: "Noise-cancelling headphones",
    image: "headphones.img" },
  { id: 2, name: "Smart Watch", price: 80, category: "electronics",
    description: "Fitness + Notifications",
    image: "watch.img" },
  { id: 3, name: "T-Shirt", price: 15, category: "fashion",
    description: "Trendy cotton tee",
    image: "t-shirt.img" },
  { id: 4, name: "Novel", price: 12, category: "books",
    description: "Bestselling story",
    image: "novel.img" },
  { id: 5, name: "Sneakers", price: 55, category: "fashion",
    description: "Stylish everyday wear",
    image: "sneakers.img" }
];

let cart = [];

const productList = document.getElementById("productList");
const cartItems = document.getElementById("cartItems");
const grandTotalEl = document.getElementById("grandTotal");

// === DISPLAY PRODUCTS ===
function displayProducts(filter = "all") {
  productList.innerHTML = "";
  let shown = filter === "all" ? products : products.filter(p => p.category === filter);

  shown.forEach(p => {
    const card = document.createElement("div");
    card.className = "product-card";
    card.innerHTML = `
      <img src="${p.image}" alt="${p.name}">
      <h3>${p.name}</h3>
      <p>${p.description}</p>
      <p><b>$${p.price}</b></p>
      <button class="add-btn" onclick="addToCart(${p.id})">Add to Cart</button>
    `;
    productList.appendChild(card);
  });
}

// === ADD TO CART ===
function addToCart(id) {
  let product = products.find(p => p.id === id);
  let item = cart.find(c => c.id === id);
  if (item) {
    item.quantity++;
  } else {
    cart.push({ ...product, quantity: 1 });
  }
  updateCart();
}

// === UPDATE CART ===
function updateCart() {
  cartItems.innerHTML = "";
  let total = 0;
  cart.forEach(item => {
    let itemTotal = item.price * item.quantity;
    total += itemTotal;
    let div = document.createElement("div");
    div.className = "cart-item";
    div.innerHTML = `
      <h4>${item.name}</h4>
      <p>$${item.price} x 
        <input type="number" min="1" value="${item.quantity}" onchange="changeQty(${item.id}, this.value)">
        = $${itemTotal}
      </p>
      <button onclick="removeItem(${item.id})">Remove</button>
    `;
    cartItems.appendChild(div);
  });
  grandTotalEl.textContent = "Grand Total: $" + total;
}

// === CHANGE QUANTITY ===
function changeQty(id, qty) {
  qty = parseInt(qty);
  if (qty < 1) { alert("Quantity must be positive"); return; }
  let item = cart.find(c => c.id === id);
  if (item) item.quantity = qty;
  updateCart();
}

// === REMOVE ITEM ===
function removeItem(id) {
  cart = cart.filter(c => c.id !== id);
  updateCart();
}

// === CLEAR CART ===
document.getElementById("clearCartBtn").addEventListener("click", () => {
  cart = [];
  updateCart();
});

// === CATEGORY FILTER ===
document.getElementById("categoryFilter").addEventListener("change", e => {
  displayProducts(e.target.value);
});

// === DARK MODE ===
document.getElementById("darkModeBtn").addEventListener("click", () => {
  document.body.classList.toggle("dark-mode");
});

// === INIT ===
displayProducts();
updateCart();