//
// For SCENARIO 1: INTERACTIVE COUNTER

if (document.title.includes("Scenario 1")) {
  let count = 0;
  const btn = document.getElementById("counterBtn");
  const display = document.getElementById("display");
  const message = document.getElementById("message");

  btn.addEventListener("click", () => {
    count++;
    display.textContent = count;
   
      message.textContent = "";
  });
}


//  For SCENARIO 2: TABBED CONTENT

if (document.title.includes("Scenario 2")) {
  const tabs = document.querySelectorAll(".tab");
  const contents = document.querySelectorAll(".tab-content");

  contents.forEach(c => (c.style.display = "none"));

  tabs.forEach(tab => {
    tab.addEventListener("click", () => {
      tabs.forEach(t => t.classList.remove("active"));
      contents.forEach(c => (c.style.display = "none"));

      tab.classList.add("active");
      document.getElementById(tab.dataset.target).style.display = "block";
    });
  });
}
// =============================
// SCENARIO 3: JOB APPLICATION FORM
// =============================
if (document.title.includes("Scenario 3")) {
  const form = document.getElementById("jobForm");
  const msg = document.getElementById("formMsg");

  form.addEventListener("submit", (e) => {
    e.preventDefault();

    const name = document.getElementById("name").value.trim();
    const email = document.getElementById("email").value.trim();
    const phone = document.getElementById("phone").value.trim();
    const gender = document.getElementById("gender").value.trim();
    const skills = document.getElementById("skills").value.trim();
    const experience = document.getElementById("experience").value.trim();
    const resumeInput = document.getElementById("resume");
    const resumeSelected = resumeInput.files.length > 0;

    const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    const phonePattern = /^[0-9]{7,15}$/; // 7–15 digits only

    if (!name || !email || !phone || !gender || !skills || !experience || !resumeSelected) {
      msg.textContent = "⚠️ All fields are required.";
      msg.style.color = "red";
    } else if (!emailPattern.test(email)) {
      msg.textContent = "⚠️ Please enter a valid email address.";
      msg.style.color = "red";
    } else if (!phonePattern.test(phone)) {
      msg.textContent = "⚠️ Phone number must contain only digits (7–15 digits).";
      msg.style.color = "red";
    } else {
      msg.textContent = "✅ Form submitted successfully!";
      msg.style.color = "green";
      form.reset();
    }
  });
}
